rm(list = ls())
source("_funciones.txt")

datos = read.table("Wissel.txt", header = T, sep=";")
head(datos)
attach(datos)

X = cbind(array(1,length(D)),C,I)
n = dim(X)[1]
k = dim(X)[2]

betah = matrix(,k,length(seq(0,1,0.1)))
i = 1
for (h in seq(0,1,0.1))
{
  betah[,i] = solve(crossprod(X)+h*diag(k))%*%crossprod(X,D)
  i = i + 1
}
betah

plot(ts(t(betah), start=0, frequency=10), plot.type="single", col=2:4, lwd=2, ylab="Estimador cresta", xlab="l")

#

reg = lm(D~C+I)
e = reg$residuals
beta = reg$coefficients
sigma2 = crossprod(e)/(n-k)
h = as.numeric(k*(sigma2/crossprod(beta)))
h
beta.h = solve(crossprod(X)+h*diag(k))%*%crossprod(X,D)
beta.h

detach(datos)
